#--------------------------------------------------------
#	Script PiXYZ STUDIO - Script 101 Demo Process
#
#	This Python script is meant to be used in PiXYZ STUDIO 2018
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#
#	This script is an example of a typical simple process to transform a CAD model into optimized mesh(es)
#
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

from pxz import *

def process():
	allScene = [[scene.getRoot()]]

	# tessellates with maxSag=0.2mm and maxAngle=10deg
	algo.tessellate(allScene, 0.2, -1, 10)

	# repairs with a tolerance of 0.1mm
	algo.repairMesh(allScene, 0.1)

	# removes through holes with diameter under 10mm
	algo.defeature(allScene, True, False, False, 10)

	# removes hidden patches
	algo.hiddenRemoval(allScene,algo.SelectionLevel.Patches, 1024, 16)

	# deletes patches to allow the decimation to remesh over the base CAD patches
	algo.deletePatches(allScene)

	# decimates with surfacic tolerance to 1mm, lineic tolerance to 0.1mm and normal distorsion tolerance to 5mm
	algo.decimate(allScene, 1, 0.1, 5)

# processes the model
process()
